/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.debug.socket;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.client.debug.socket.DebugConnection;
import java.util.UUID;
import net.minecraft.class_1160;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SocketDebugService {
    private static final Logger LOGGER = LogManager.getLogger(SocketDebugService.class);
    private static final Gson GSON = new Gson();
    private static final boolean enable = true;
    private static final class_310 mc = class_310.method_1551();
    private static final String hostName = "localhost";
    private static final int port = 1919;
    public static DebugConnection connection;
    private static class_1160 rawAngle;
    private static class_1160 angle;
    private static class_1160 oldAngle;
    private static boolean yAngleFlag;
    private static boolean zAngleFlag;
    private static class_1160 rawPosition;
    private static class_1160 position;
    private static class_1160 oldPosition;

    public static void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        ConnectionThread ct = new ConnectionThread();
        ct.start();
    }

    public static void tick() {
        oldAngle = angle;
        angle = rawAngle;
        oldPosition = position;
        position = rawPosition;
    }

    public static void onText(String text) {
        try {
            UUID uuid = UUID.fromString(text);
            connection.sendText(uuid.toString());
            return;
        }
        catch (Exception uuid) {
            try {
                JsonObject jo = (JsonObject)GSON.fromJson(text, JsonObject.class);
                SocketDebugService.parse(jo);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    private static void parse(JsonObject jo) {
        if (!jo.has("type")) {
            return;
        }
        String type = jo.get("type").getAsString();
        if ("update".equals(type)) {
            yAngleFlag = jo.get("ayflg").getAsBoolean();
            zAngleFlag = jo.get("azflg").getAsBoolean();
            rawAngle = SocketDebugService.createAngle(jo.get("ax").getAsFloat(), SocketDebugService.fixP(jo.get("ay").getAsFloat(), yAngleFlag, zAngleFlag), jo.get("az").getAsFloat());
            boolean yFixAngleFlag = jo.get("ayflgf").getAsBoolean();
            boolean zFixAngleFlag = jo.get("azflgf").getAsBoolean();
            class_1160 fAngle = SocketDebugService.createAngle(jo.get("axf").getAsFloat(), SocketDebugService.fixP(jo.get("ayf").getAsFloat(), yFixAngleFlag, zFixAngleFlag), jo.get("azf").getAsFloat());
            rawAngle.method_4944(fAngle);
            rawAngle = new class_1160(SocketDebugService.fixRoted(rawAngle.method_4943()), SocketDebugService.fixRoted(rawAngle.method_4945()), SocketDebugService.fixRoted(rawAngle.method_4947()));
            rawPosition = new class_1160(jo.get("px").getAsFloat(), jo.get("py").getAsFloat(), jo.get("pz").getAsFloat());
        }
    }

    private static float fixP(float va, boolean revY, boolean revZ) {
        va = 90.0f - va;
        if (revY) {
            va = 180.0f - va + 180.0f;
        }
        return va;
    }

    private static class_1160 createAngle(float rx, float ry, float rz) {
        return new class_1160(360.0f - SocketDebugService.fixRoted(rx), (SocketDebugService.fixRoted(ry) - 180.0f) % 360.0f, SocketDebugService.fixRoted(rz));
    }

    private static float fixRoted(float val) {
        if (val < 0.0f) {
            return 360.0f + val;
        }
        return val;
    }

    private static float lerpRoted(float delta, float old, float current) {
        float mr = 180.0f;
        float sa = class_3532.method_15379((float)(current - old));
        if (sa > mr) {
            current = old < current ? -(360.0f - current) : 360.0f + current;
        }
        return class_3532.method_16439((float)delta, (float)old, (float)current);
    }

    public static class_1160 getAngele(float delta) {
        return new class_1160(SocketDebugService.lerpRoted(delta, oldAngle.method_4943(), angle.method_4943()), SocketDebugService.lerpRoted(delta, oldAngle.method_4945(), angle.method_4945()), SocketDebugService.lerpRoted(delta, oldAngle.method_4947(), angle.method_4947()));
    }

    public static class_1160 getPosition(float delta) {
        return new class_1160(class_3532.method_16439((float)delta, (float)oldPosition.method_4943(), (float)position.method_4943()), class_3532.method_16439((float)delta, (float)oldPosition.method_4945(), (float)position.method_4945()), class_3532.method_16439((float)delta, (float)oldPosition.method_4947(), (float)position.method_4947()));
    }

    public static boolean isConnected() {
        if (connection != null) {
            return connection.isOpen();
        }
        return false;
    }

    private static void connect(String hostName, int port) throws InterruptedException {
        while (mc.method_22108()) {
            connection = new DebugConnection(hostName, port);
            try {
                connection.run();
            }
            catch (Exception e) {
                LOGGER.error("Socket connection error", (Throwable)e);
                Thread.sleep(1000L);
            }
            finally {
                connection = null;
            }
        }
    }

    static {
        rawAngle = new class_1160();
        angle = new class_1160();
        oldAngle = new class_1160();
        rawPosition = new class_1160();
        position = new class_1160();
        oldPosition = new class_1160();
    }

    private static class ConnectionThread
    extends Thread {
        private ConnectionThread() {
            this.setName("Debug connection");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                SocketDebugService.connect(SocketDebugService.hostName, 1919);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

